#!/usr/bin/env python

# Copyright (c) 2018, Martin Cerveny
# SPDX-License-Identifier: BSD-3-Clause

# programmer for SPI dataflash AT45DB041D

import spidev
import time
import sys
import R64.GPIO as GPIO

PIN_CS = 26
GPIO.setmode(GPIO.BOARD)
GPIO.setup(PIN_CS, GPIO.OUT, initial=GPIO.HIGH)

def xfer(data):
    GPIO.output(PIN_CS, GPIO.LOW)
    ret = spi.xfer(data)
    GPIO.output(PIN_CS, GPIO.HIGH)
    return ret

spi = spidev.SpiDev()
spi.open(32766,1)
spi.max_speed_hz = 5000000
spi.mode = 0b11

resp = xfer([0x9f] + [0]*6)
print 'JEDEC:', ''.join('{:02x} '.format(x) for x in resp[1:])
print

if len(sys.argv)>1:
    cmd=sys.argv[1]
else:
    cmd=""

if cmd == "sector":
    print "sector mode 264->256 ..."
    resp =xfer([0x3d, 0x2a, 0x80, 0xa6])

elif cmd == "erase":
    print "chip erase ..."
    resp = xfer([0xc7, 0x94, 0x80, 0x9a])
    resp = xfer([0xD7] + [0])
    while resp[1] & 0x80 == 0x00:
        time.sleep(0.1)
        resp = xfer([0xD7] + [0])
        print "wait ",
    print "done"

elif cmd == "compare":
    print "compare ..."
    f = open(sys.argv[2], 'rb')
    data = f.read()
    data += chr(255)*(2048 - len(data) % 2048)
    for addr in range(0, len(data), 2048):
        resp = xfer([0x03, addr/256/256, (addr/256)%256, 0] + [0]*2048)
        if resp[4:] != map(ord,data[addr:(addr+2048)]):
            print 'NOT MATCH %08x\nDATA:\n' % addr, ''.join('{:02x} '.format(x) for x in map(ord, data[addr:(addr+2048)])), '\nFLASH:\n', ''.join('{:02x} '.format(x) for x in resp[4:])

elif cmd == "write":
    print "write ..."
    f = open(sys.argv[2], 'rb')
    data = f.read()
    data += chr(255)*(2048 - len(data) % 2048)
    for addr in range(0, len(data), 256):
        # write pages
        resp = xfer([0x82, addr/256/256, (addr/256)%256, 0] + map(ord, data[addr:(addr+256)]))
        print '\n%08x size %x:' % (addr, len(data[addr:(addr+256)])), ''.join('{:02x} '.format(x) for x in map(ord, data[addr:(addr+4)])), "... ", 
        resp = xfer([0xD7] + [0])
        while resp[1] & 0x80 == 0x00:
            time.sleep(0.001)
            resp = xfer([0xD7] + [0])
            print "wait ",

else:
   print "run with parameters 'sector' or 'erase' or 'compare file' or 'write file'"

GPIO.cleanup(PIN_CS)

